#ifndef __SMenuColours__
#define __SMenuColours__

#include "../Basics/CAlphaColour.hpp"
using Exponent::GUI::Basics::CAlphaColour;

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @struct SMenuColours SMenuColours.hpp
			 * @brief Stores all the colours required for a menu widnow
			 *
			 * @date 17/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: SMenuColours.hpp,v 1.4 2007/02/08 21:07:54 paul Exp $
			 */
			struct SMenuColours
			{
				CAlphaColour m_textColour;				/**< The colour of the text */
				CAlphaColour m_disabledTextColour;		/**< The colour of disabled text */
				CAlphaColour m_seperatorColour;			/**< The colour of the seperator */
				CAlphaColour m_subMenuPointerColour;	/**< The colour of the sub menu pointer */
				CAlphaColour m_frameColour;				/**< The colour of the frame */
				CAlphaColour m_selectedColour;			/**< The colour of the selection */
			};
		}
	}
}
#endif	// End of SMenuColours.hpp